% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QMLE.R
\name{BayesianExgaussian}
\alias{BayesianExgaussian}
\title{Bayesian Ex-gaussian Estimate}
\usage{
BayesianExgaussian(n, x, nSamples = 5000, Ti = 2500)
}
\arguments{
\item{n}{the data size}

\item{x}{the data. Must be a vector, with no missing values}

\item{nSamples}{number of Samples}

\item{Ti}{burn-in}
}
\value{
BayesianExgaussian() returns an object "theta" which is a list with components: estimates of mu, sigma, and tau
}
\description{
Estimates the mu, sigma, and tau parameters of an ex-Gaussian distribution using a bayesian method.
}
\examples{
\donttest{library(gamlss.dist)
set.seed(2703)
data<-rexGAUS(n=100, mu = 500, sigma = 150, nu = 100)
BayesianExgaussian(n = 100, x = data)}

}
\references{
Brown, S., & Heathcote, A. (2003). QMLE: Fast, robust, and efficient estimation of distribution functions based on quantiles. \emph{Behavior Research Methods, Instruments, & Computers}, \strong{35}, 485-492. 

McCormack, P. D., & Wright, N. M. (1964). The positive skew observed in reaction time distributions. \emph{Canadian Journal of Psychology/Revue canadienne de psychologie}, \strong{18}, 43-51. 

Van Zandt, T. (2000). How to fit a response time distribution. \emph{Psychonomic Bulletin & Review}, \strong{7}, 424-465.

El Haj, A., Slaoui, Y., Solier, C., & Perret, C. (2021). Bayesian Estimation of The Ex-Gaussian distribution. \emph{Statistics, Optimization & Information Computing}, \strong{9(4)}, 809-819.

Gilks, W. R., Best, N. G., & Tan, K. K. C. (1995). Adaptive rejection Metropolis sampling within Gibbs sampling. \emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, \strong{44}, 455-472.
}
