% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stressed_factors.R
\name{get_stressed_factors.fars}
\alias{get_stressed_factors.fars}
\title{Extract Stressed Factors from a \code{fars} Object}
\usage{
\method{get_stressed_factors}{fars}(x, ...)
}
\arguments{
\item{x}{An object of class \code{fars}.}

\item{...}{Additional arguments (ignored).}
}
\value{
A matrix containing the stressed factors if available, otherwise NULL.
}
\description{
Extracts the stressed factors from a \code{fars} object. If stressed factors are not available,
it returns NULL.
}
\examples{
fars_result <- compute_fars(dep_variable = rnorm(100), factors = matrix(rnorm(100 * 3), ncol = 3))
get_stressed_factors(fars_result)  

}
