% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mlp_prune.R
\name{mlp_prune_mag}
\alias{mlp_prune_mag}
\title{Minimum magnitude pruning}
\usage{
mlp_prune_mag(net, input, output, tol_level, max_reteach_epochs, report,
  plots = FALSE)
}
\arguments{
\item{net}{an object of \code{mlp_net} class}

\item{input}{numeric matrix, each row corresponds to one input vector
number of columns must be equal to the number of neurons
in the network input layer}

\item{output}{numeric matrix with rows corresponding to expected outputs,
number of columns must be equal to the number of neurons
in the network output layer, number of rows must be equal to the number
of input rows}

\item{tol_level}{numeric value, error (MSE) tolerance level}

\item{max_reteach_epochs}{integer value, maximal number of epochs (iterations) allowed
when reteaching network}

\item{report}{logical value, if TRUE, information about the pruning process
will be printed on the console (FALSE by default)}

\item{plots}{logical value, if TRUE, the initial network is plotted and then
       replotted every time weight or neuron is removed (FALSE by default)}
}
\value{
Three-element list, the first field (\code{net}) contains the pruned network,
        the second (\code{wcount}) - the number of connections removed (inactivated),
        the third (\code{ncount}) - the number of neurons removed.
}
\description{
Minimum magnitude pruning is a brute force, easy-to-implement pruning algorithm
in which in each step the weight with the smallest absolute value is turned off. This
algorithm requires reteaching network in almost every step and yields suboptimal results.
}
\keyword{pruning}

