% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcf.R
\name{pcf}
\alias{pcf}
\title{Pair Correlation Function}
\usage{
pcf(img, nPoints = 1000, one.col = FALSE, dr = 1)
}
\arguments{
\item{img}{The image to analyze}

\item{nPoints}{The size of the sub-vectors in which the input vectors will be divided. This number must be less than N/2.}

\item{one.col}{By default FALSE. If TRUE the correlation will be performed in the fixed colum mode, else the distance mode.}

\item{dr}{Distance between pixel at which the correlation is calculated. For a value of delta_r = 3, the columns are correlated as follows: (1,4), (2,5), ..., (n-3, n), with n being the last column.}
}
\value{
An image depicting the correlation between the pixel i and pixel i + dr.
}
\description{
Calculates the correlation between the pixel i and pixel i + dr.
}
\details{
The pair correlation function (pCF) analyzes data of a periodically scanned line, measuring the time it takes a particle to go from one pixel to another, i.e. calculates the spatial cross-correlation function
between pixels.
G(tau,deltar) = (<F(t,0) F(t + tau, deltar)>/<F(t,0)> <F(t,deltar)>)-1
}
\examples{
\donttest{
### Load the FCSlib package

library(FCSlib)

### As an example, we will use a data set that corresponds to a population of Venus dimers
# diffusing in HEK-293 cells. Use the readFileTiff() function to extract the information
# from the '.tiff' files.

dmv2 <- data.matrix(V2)
pB <- pcf(dmv2, nPoints = 2500, dr = 10)

### Plot the result
library(fields)
di <- dim(pB)
tau <- (1:(di[2]))
image.plot( x = 1:di[1], y = log10(tau), z = pB, main = "Column Distance 10",
xlab = "Pixel", ylab = "Logarithmic tau",
cex.lab = 1.2, cex.main = 1.2, cex.axis = 1)
}
}
\seealso{
\code{\link{fcs}, \link{pcomb}}
}
\author{
Raúl Pinto Cámara.
}
