% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.FDboost}
\alias{predict.FDboost}
\title{Prediction for boosted functional regression model}
\usage{
\method{predict}{FDboost}(object, newdata = NULL, which = NULL,
  toFDboost = TRUE, ...)
}
\arguments{
\item{object}{a fitted \code{FDboost}-object}

\item{newdata}{a named list or a data frame containing the values of the model
covariates at which predictions are required.
If this is not provided then predictions corresponding to the original data are returned.
If \code{newdata} is provided then it should contain all the variables needed for
prediction, in the format supplied to \code{FDboost}, i.e.,
functional predictors must be supplied as matrices with each row corresponding to
one observed function.}

\item{which}{a subset of base-learners to take into account for computing predictions
or coefficients. If which is given (as an integer vector corresponding to base-learners)
a list is returned.}

\item{toFDboost}{logical, defaults to \code{TRUE}. In case of regular response in wide format
(i.e. response is supplied as matrix): should the predictions be returned as matrix, or list
of matrices instead of vectors}

\item{...}{additional arguments passed on to \code{\link[mboost]{predict.mboost}()}.}
}
\value{
a matrix or list of predictions depending on values of unlist and which
}
\description{
Takes a fitted \code{FDboost}-object produced by \code{\link{FDboost}()} and produces
 predictions given a new set of values for the model covariates or the original
 values used for the model fit. This is a wrapper
 function for \code{\link[mboost]{predict.mboost}()}
}
\seealso{
\code{\link{FDboost}} for the model fit
and \code{\link{plotPredicted}} for a plot of the observed values and their predictions.
}

