% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spGetPlots.R
\name{spGetPlots}
\alias{spGetPlots}
\title{Spatial wrapper - Extracts plot data within a given boundary.}
\usage{
spGetPlots(
  bnd = NULL,
  bnd_dsn = NULL,
  bnd.filter = NULL,
  states = NULL,
  RS = NULL,
  pltids = NULL,
  xy_datsource = NULL,
  xy_dsn = NULL,
  xy = "PLOT",
  xy_opts = xy_options(),
  datsource = NULL,
  data_dsn = NULL,
  dbTabs = dbTables(),
  eval = "FIA",
  eval_opts = NULL,
  puniqueid = "CN",
  invtype = "ANNUAL",
  intensity1 = FALSE,
  istree = FALSE,
  isseed = FALSE,
  isveg = FALSE,
  issubp = FALSE,
  ischng = FALSE,
  isdwm = FALSE,
  biojenk = FALSE,
  greenwt = FALSE,
  plotgeom = FALSE,
  othertables = NULL,
  ACI = FALSE,
  clipxy = TRUE,
  pjoinid = NULL,
  showsteps = FALSE,
  returndata = TRUE,
  savedata = FALSE,
  savePOP = FALSE,
  savebnd = FALSE,
  returnxy = TRUE,
  exportsp = FALSE,
  savedata_opts = NULL,
  spXYdat = NULL,
  gui = FALSE,
  ...
)
}
\arguments{
\item{bnd}{sf R object, Area of Interest (AOI) boundary. Can be a spatial sf
object, full pathname to a shapefile, or name of a layer within a database.}

\item{bnd_dsn}{String. Data source name (dsn; e.g., SQLite database or shapefile
pathname) of bnd. The dsn varies by driver. See gdal OGR vector formats
(https://www.gdal.org/ogr_formats.html). Optional if bnd is an R object.}

\item{bnd.filter}{String. Filter to subset bnd spatial layer.}

\item{states}{String. The name of state(s) for tables (e.g., "Vermont", "Utah").}

\item{RS}{String. Name of FIA research station to restrict states to
('RMRS','SRS','NCRS','NERS','PNWRS'). If NULL, all research stations are
included.}

\item{pltids}{Data frame. Non-spatial plot identifiers within bnd).}

\item{xy_datsource}{String. Source of XY data ("obj", "csv", "datamart",
"sqlite").  If datsource=NULL, checks extension of xy_dsn or xy to identify
datsource.}

\item{xy_dsn}{String. Data source name (dsn; i.e., pathname or database
name) of xy. The dsn varies by driver. See gdal OGR vector formats
(https://www.gdal.org/ogr_formats.html). Optional if bnd_layer is an R
object.}

\item{xy}{sf R object or String. Table with xy coordinates. Can be a spatial
polygon object, data frame, full pathname to a shapefile, or name of a layer
within a database.}

\item{xy_opts}{List of xy data options to specify if xy is NOT NULL. 
See xy_options (e.g., xy_opts = list(xvar='LON', yvar='LAT').}

\item{datsource}{String. Source of FIA data ("obj", "csv", "datamart",
"sqlite").  If datsource="sqlite", specify database name in data_dsn and
layers in *_layer arguments.  If datsource="datamart", files are downloaded
and extracted from FIA DataMart
(http://apps.fs.usda.gov/fia/datamart/datamart.html). See details for more
information about plot coordinates.  If datsource="csv", specify *.csv file
names in *_layer arguments.}

\item{data_dsn}{String. Name of database where *_layers reside.}

\item{dbTabs}{List of database tables the user would like returned.
See help(dbTables) for a list of options.}

\item{eval}{String. Type of evaluation time frame for data extraction 
('FIA', 'custom'). See eval_opts for more further options.}

\item{eval_opts}{List of evaluation options for 'FIA' or 'custom'
evaluations to determine the set of data returned. See help(eval_options)
for a list of options.}

\item{puniqueid}{String. Name of unique identifier of plt.}

\item{invtype}{String. Type of FIA inventory to extract ('PERIODIC',
'ANNUAL').  Only one inventory type (PERIODIC/ANNUAL) at a time.}

\item{intensity1}{Logical. If TRUE, includes only XY coordinates where 
INTENSITY = 1 (FIA base grid).}

\item{istree}{Logical. If TRUE, tree data are extracted from TREE table in
database.}

\item{isseed}{Logical. If TRUE, seedling data are extracted from SEEDLING
table in database.}

\item{isveg}{Logical. If TRUE, understory vegetation tables are extracted
from FIA database (P2VEG_SUBPLOT_SPP, P2VEG_SUBP_STRUCTURE, INVASIVE_SUBPLOT_SPP).}

\item{issubp}{Logical. If TRUE, subplot tables are extracted from FIA
database (SUBPLOT, SUBP_COND).}

\item{ischng}{Logical. If TRUE, sccm (SUBP_COND_CHNG_MTRX) table is returned 
that includes current and previous conditions.}

\item{isdwm}{Logical. If TRUE, summarized condition-level down woody debris
data are extracted from FIA database (COND_DWM_CALC).}

\item{biojenk}{Logical. If TRUE, Jenkins biomass is calculated.}

\item{greenwt}{Logical. If TRUE, green weight biomass is calculated.}

\item{plotgeom}{Logical. If TRUE, variables from the PLOTGEOM table are
appended to the plot table.}

\item{othertables}{String Vector. Name of other table(s) in FIADB to include
in output. The table must have PLT_CN as unique identifier of a plot.}

\item{ACI}{Logical. If TRUE, the data from All Condition Inventories (ACI)
are included in dataset (NF_SAMPLING_STATUS_CD = 1). See below for more
details.}

\item{clipxy}{Logical. If TRUE, clips xy data to bnd.}

\item{pjoinid}{String. Variable in plt to join to XY data. Not necessary to
be unique. If using most current XY coordinates, use identifier for a plot
(e.g., PLOT_ID).}

\item{showsteps}{Logical. If TRUE, display data in device window.}

\item{returndata}{Logical. If TRUE, returns data objects.}

\item{savedata}{Logical. If TRUE, saves data to outfolder.}

\item{savePOP}{Logical. If TRUE, save and return the POP_PLOT_STRATUM_ASSGN
table.}

\item{savebnd}{Logical. If TRUE, saves bnd. If out_fmt='sqlite', saves to a
SpatiaLite database.}

\item{returnxy}{Logical. If TRUE, save xy coordinates to outfolder.}

\item{exportsp}{Logical. If returnxy=TRUE, if TRUE, saves xy data as 
spatial data. If FALSE, saves xy data as table.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}

\item{spXYdat}{R list object. Output from spGetXY().}

\item{gui}{Logical. If TRUE, uses gui interface.}

\item{...}{parameters passed to DBgetPlot().}
}
\value{
\item{xypltx}{ sf object. Input xy data clipped to boundary. }
\item{bndx}{ sf object. Input bnd. } \item{tabs}{ list object. List of input
layers clipped to boundary (pltx,condx,etc.). } \item{xy.uniqueid}{ String.
Name of unique identifier of xy. } \item{puniqueid}{ String. Name of unique
identifier of plot in plt. } \item{pjoinid}{ String. Name of unique
identifier of plot in plt. }

If savedata=TRUE, outdat data frame is saved to outfolder.
}
\description{
Wrapper to get FIA plots within the boundary population (area of interest) -
Intersect with state boundary - Get FIA plots for intersected states,
including tree, and spatial - Clip spatial coordinates and other tables to
boundary (spClipPoint)
}
\details{
\bold{datsource}

Plots are extracted from 3 different data sources:\cr 1) CSV - data have
previously been extracted from the FIA database and stored as CSV files.\cr
2) datamart - data are extracted from FIA's publically-available
datamart.\cr 3) sqlite - data have previously been extracted from the FIA
database and stored within a SQLite database.\cr

\bold{Selection parameters}

FIA plots are selected based on the following parameters:\cr \tabular{ll}{
\tab evalid - the FIA evaluation identifier\cr \tab evalCur - the most
current FIA evaluation in database\cr \tab evalEndyr - the FIA evaluation
ending in evalEndyr\cr \tab evalType - the FIA evaluation type ('ALL',
'AREAVOL', 'GRM', 'P2VEG', 'DWM', 'INV', 'REGEN', 'CRWN')\cr \tab measCur -
the most current measurement of each plot in database\cr \tab measEndyr -
the most current measuremtn of each plot in database in or prior to
measEndyr\cr \tab Endyr.filter - a filter for bnd that specifies the
boundary where measEndyr should be applied\cr }
}
\note{
If savebnd=TRUE:\cr If out_fmt=c('csv','shp'), the writeOGR (rgdal) function
is called. The ArcGIS driver truncates variable names to 10 characters or
less. Variable names are changed before export using an internal function
(trunc10shp). If Spatial object has more than 1 record, it will be returned
but not exported.

If datsource="datmart", data are imported from FIA DataMart.  The plot
coordinates have been altered for privacy (See
https://www.fia.fs.fed.us/tools-data/spatial/Policy/index.php for details).
The zip files are extracted on-the-fly from the online website. Web server
connections will affect download speeds.
}
\examples{
\dontrun{
# Get polygon vector layer from FIESTA external data
WYbhfn <- system.file("extdata",
                      "sp_data/WYbighorn_adminbnd.shp",
                      package = "FIESTA")

# Extract data from FIA datamart for measurement years 2013 thru 2015
dat <- spGetPlots(bnd = WYbhfn,
                  datsource = "datamart",
                  eval = "custom",
                  eval_opts = list(measyrs = 2013:2015))
names(dat)
tabs <- dat$tabs
names(tabs)
head(tabs$plt)

table(tabs$plt$MEASYEAR)

# Extract data from FIA datamart for most current evaluation
datCur <- spGetPlots(bnd = WYbhfn,
                     datsource = "datamart",
                       eval = "FIA",
                     eval_opts = list(Cur = TRUE))
names(datCur)
tabsCur <- datCur$tabs
names(tabsCur)
head(tabsCur$plt)

table(tabsCur$plt$MEASYEAR)
} 
}
\author{
Tracey S. Frescino
}
\keyword{data}
