% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{FMAT_query}
\alias{FMAT_query}
\title{Prepare a data.table of queries and variables for the FMAT.}
\usage{
FMAT_query(
  query = "Text with [MASK], optionally with {TARGET} and/or {ATTRIB}.",
  MASK = .(),
  TARGET = .(),
  ATTRIB = .()
)
}
\arguments{
\item{query}{Query text (should be a character string/vector
with at least one \verb{[MASK]} token).
Multiple queries share the same set of
\code{MASK}, \code{TARGET}, and \code{ATTRIB}.
For multiple queries with different
\code{MASK}, \code{TARGET}, and/or \code{ATTRIB},
please use \code{\link{FMAT_query_bind}} to combine them.}

\item{MASK}{A named list of \verb{[MASK]} target words.
Must be single words in the vocabulary of a certain masked language model.

For model vocabulary, see, e.g.,
\url{https://huggingface.co/bert-base-uncased/raw/main/vocab.txt}

Infrequent words may be not included in a model's vocabulary,
and in this case you may insert the words into the context by
specifying either \code{TARGET} or \code{ATTRIB}.}

\item{TARGET, ATTRIB}{A named list of Target/Attribute words or phrases.
If specified, then \code{query} must contain
\code{{TARGET}} and/or \code{{ATTRIB}} (in all uppercase and in braces)
to be replaced by the words/phrases.}
}
\value{
A data.table of queries and variables.
}
\description{
Prepare a data.table of queries and variables for the FMAT.
}
\examples{
\donttest{FMAT_query("[MASK] is a nurse.", MASK = .(Male="He", Female="She"))

FMAT_query(
  c("[MASK] is {TARGET}.", "[MASK] works as {TARGET}."),
  MASK = .(Male="He", Female="She"),
  TARGET = .(Occupation=c("a doctor", "a nurse", "an artist"))
)

FMAT_query(
  "The [MASK] {ATTRIB}.",
  MASK = .(Male=c("man", "boy"),
           Female=c("woman", "girl")),
  ATTRIB = .(Masc=c("is masculine", "has a masculine personality"),
             Femi=c("is feminine", "has a feminine personality"))
)
}
}
\seealso{
\code{\link{FMAT_load}}

\code{\link{FMAT_query_bind}}

\code{\link{FMAT_run}}
}
