% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CIDists.R
\name{binCI}
\alias{binCI}
\title{Confidence intervals for binomial probability of success.}
\usage{
binCI(x, n, conf.level = 0.95, type = c("wilson", "exact", "asymptotic",
  "all"))
}
\arguments{
\item{x}{A single or vector of numbers that contains the number of observed successes.}

\item{n}{A single or vector of numbers that contains the sample size.}

\item{conf.level}{A single number that indicates the level of confidence (default is \code{0.95}).}

\item{type}{A string that identifies the type of method to use for the calculations.  See details.}
}
\value{
A #x2 matrix that contains the lower and upper confidence interval bounds as columns.
}
\description{
Uses one of three methods to compute a confidence interval for the probability of success (p) in a binomial distribution.
}
\details{
This function will compute confidence interval for three possible methods chosen with the \code{type} argument.

\tabular{ll}{
 \code{type="wilson"} \tab Wilson's (Journal of the American Statistical Association, 1927) confidence interval for a proportion.  This is the score CI, based on inverting the asymptotic normal test using the null standard error. \cr
 \code{type="exact"} \tab Computes the Clopper/Pearson exact CI for a binomial success probability. \cr
 \code{type="asymptotic"} \tab This uses the normal distribution approximation. \cr
}

Note that Agresti and Coull (2000) suggest that the Wilson interval is the preferred method and is, thus, the default \code{type}.
}
\note{
This is primarily a wrapper function for \code{\link[Hmisc]{binconf}} in the \pkg{Hmisc} package (this implementation uses arguments, specificially \code{conf.level}, that more closely match other functions).
}
\examples{
binCI(7,20,type="wilson")
binCI(7,20,type="exact")
binCI(7,20,type="asymptotic")

## Demonstrates using all types at once
binCI(7,20,type="all")

## Demonstrates use with multiple inputs
binCI(c(7,10),c(20,30))
}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\references{
Agresti, A. and B.A. Coull.  1998.  Approximate is better than \dQuote{exact} for interval estimation of binomial proportions.  American Statistician, 52:119-126.
}
\seealso{
See \code{\link{binom.test}}, \code{\link[Hmisc]{binconf}} in \pkg{Hmisc}, \code{\link[epitools]{binom.conf.int}} in \pkg{epitools}, and functions in \pkg{binom}.
}
\keyword{htest}

