% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSAUtils.R
\name{col2rgbt}
\alias{col2rgbt}
\title{Converts an R color to RGB (red/green/blue) including a transparency (alpha channel).}
\usage{
col2rgbt(col, transp = 1)
}
\arguments{
\item{col}{A vector of any of the three kinds of R color specifications (i.e., either a color name (as listed by \code{\link[grDevices]{colors}}()), a hexadecimal string of the form "#rrggbb" or "#rrggbbaa" (see \code{\link[grDevices]{rgb}}), or a positive integer i meaning \code{\link[grDevices]{palette}}()[i].}

\item{transp}{A numeric vector that indicates the transparency level for the color.  The transparency values must be greater than 0.  Transparency values greater than 1 are interpreted as the number of points plotted on top of each other before the transparency is lost and is, thus, transformed to the inverse of the transparency value provided.}
}
\value{
A vector of hexadecimal strings of the form "#rrggbbaa" as would be returned by \code{\link[grDevices]{rgb}}.
}
\description{
Converts an R color to RGB (red/green/blue) including a transparency (alpha channel).  Similar to \code{\link[grDevices]{col2rgb}} except that a transparncy (alpha channel) can be included.
}
\examples{
col2rgbt("black")
col2rgbt("black",1/4)
clrs <- c("black","blue","red","green")
col2rgbt(clrs)
col2rgbt(clrs,1/4)
trans <- (1:4)/5
col2rgbt(clrs,trans)

}
\author{
Derek H. Ogle, \email{derek@derekogle.com}
}
\seealso{
See \code{\link[grDevices]{col2rgb}} for similar functionality.
}
\keyword{manip}

