% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMSE.R
\name{compute.rmse}
\alias{compute.rmse}
\title{Root Mean Square Error (RMSE)}
\usage{
compute.rmse(Y, X)
}
\arguments{
\item{Y}{vector of imputed values}

\item{X}{vector of true values}
}
\description{
Calculate the FA2 between two univariate signals Y (imputed values) and X (true values).
}
\details{
This function computes the value of RMSE of two univariate signals.
A lower RMSE (\eqn{RMSE \in [0, \inf]}) value demonstrates a better performance method for the imputation task.
The length of the two vectors Y and X must be equal, on the contrary an error will be displayed.
In both input vectors, eventual NA will be exluded with a warning diplayed.
}
\examples{
data(dataFSMUMI)
X <- dataFSMUMI[, 1] ; Y <- dataFSMUMI[, 2]
compute.rmse(Y,X)
}
\author{
Thi-Thu-Hong Phan, Andre Bigand, Emilie Poisson-Caillault
}
