% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaheuristic.R
\name{woa}
\alias{woa}
\title{Whale Optimization Algorithm (Binary Whale Optimization Algorithm)}
\usage{
woa(data, class, featureSetEval, population = 10, iter = 10,
  verbose = FALSE)
}
\arguments{
\item{data}{\itemize{
\item A data frame with the features and the class of the examples
}}

\item{class}{\itemize{
\item The name of the dependent variable
}}

\item{featureSetEval}{\itemize{
\item The measure for evaluate features
}}

\item{population}{\itemize{
\item The number of whales population
}}

\item{iter}{\itemize{
\item The number of iterations of the algorithm
}}

\item{verbose}{\itemize{
\item Print the partial results in each iteration
}}
}
\value{
A list is returned containing for each repetition of the algorithm:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0}
\item{bestFitness}{Evaluation measure obtained with the feature selection}
\item{popIter}{List that contains as many elements as iterations has the algorithm. Each of the elements in the list are matrices that represent the population in that iteration. In this matrix the individuals and the evaluation measure of each one are shown}
}
}
\description{
Binary Whale Optimization Algorithm \insertCite{Kumar2018}{FSinR} is an algorithm that simulates the social behavior of humpback whales. This algorithm employs a binary version of the bubble-net hunting strategy. The algorithm starts with an initial population of individuals, and in each iteration updates the individuals according to several possible actions: Encircling prey, Bubble-net attacking or Search for prey
}
\examples{
## Whale Optimization Algorithm for iris dataset (filter method)
woa(iris, 'Species', roughsetConsistency, population = 10, iter = 5, verbose = TRUE)
}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
