% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectIndividualFeatures.R
\name{selectDifference}
\alias{selectDifference}
\title{Select difference}
\usage{
selectDifference(d.threshold = 0.2)
}
\arguments{
\item{d.threshold}{\itemize{
\item Number between 0 and 1, to calculate the slope
}}
}
\value{
Returns a direct search function that is used in the feature selection process.
}
\description{
Generates a direct search function that selects features (in descending order from the best evaluation measure to the lowest) until evaluation difference is over a threshold (The features evaluation is individual). This function is called internally within the \code{\link{directSearchAlgorithm}} function.
}
\examples{
\dontrun{ 

## The direct application of this function is an advanced use that consists of using this 
# function directly and performing a direct search process
## Classification problem


# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('determinationCoefficient')

# Generates the direct search function with difference
sd_direct_search <- selectDifference()
# Performs the direct search process directly (parameters: dataset, target variable and evaluator)
sd_direct_search(iris, 'Species', filter_evaluator)
}
}
\author{
Adan M. Rodriguez

Francisco Aragón Royón
}
