% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directFeatureSelection.R
\name{directFeatureSelection}
\alias{directFeatureSelection}
\title{Direct Feature Selection Proccess}
\usage{
directFeatureSelection(data, class, directSearcher, evaluator)
}
\arguments{
\item{data}{A data.frame with the input dataset where the examples are in the rows and the features and the target variable are in the columns. The dataset should be discrete (feature columns are expected to be factors) if the following filter methods are used as evaluation methods: Rough Set Consistency, Binary Consistency, IE Consistency, IEP Consistency, Mutual Information, Gain Ratio, Symmetrical Uncertain, Gini Index or MDLC. The Jd and F-Score filter methods only work on classification problems with 2 classes in the target variable.}

\item{class}{The name of the dependent variable}

\item{directSearcher}{The algorithm to conduct the direct feature search. See \code{\link{directSearchAlgorithm}}.}

\item{evaluator}{The evaluation method to obtain a measure of the features. The evaluation method can be a filter (see \code{\link{filterEvaluator}}) or a wrapper method (see \code{\link{wrapperEvaluator}}).}
}
\value{
A list is returned with the results of the direct feature selection process:
\describe{
\item{bestFeatures}{A vector with all features. Selected features are marked with 1, unselected features are marked with 0.}
\item{featuresSelected}{The names of the returned features sorted according to the result of the evaluation measure}
\item{valuePerFeature}{The evaluation measures of the returned features}
\item{evaluationType}{Type of evaluation based on how the features have been evaluated.}
\item{evaluationMethod}{Evaluation method used.}
\item{searchMethod}{Search method used during the feature selection process.}
\item{target}{A character indicating if the objective of the process is to minimize or maximize the evaluation measure.}
\item{numFeatures}{Number of features in the problem.}
\item{xNames}{Name of the features.}
\item{yNames}{Name of the dependent variable.}
\item{time}{Value of class 'proc_time' containing the user time, system time, and total time of the feature selection process.}
}
}
\description{
Performs the direct feature selection process. Given a direct search algorithm and an evaluation method, it uses the direct search algorithm in combination with the evaluation results to guide the feature selection process to an optimal subset.
}
\examples{
\donttest{ 

## Examples of the direct feature selection process
## Classification problem with filter

# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('ReliefFeatureSetMeasure')
# Generates the direct search function
direct_search_method <- directSearchAlgorithm('selectKBest')
# Runs the direct feature selection process
res <- directFeatureSelection(iris, 'Species', direct_search_method, filter_evaluator)


## Classification problem with wrapper

# Generates the wraper evaluation function
wrapper_evaluator <- wrapperEvaluator('knn')
# Generates the direct search function
direct_search_method <- directSearchAlgorithm('selectKBest')
# Runs the direct feature selection process
res <- directFeatureSelection(iris, 'Species', direct_search_method, wrapper_evaluator)


## Examples of the direct feature selection process (with parameters)
## Regression problem with filter

# Generates the filter evaluation function
filter_evaluator <- filterEvaluator('relief', list(neighbours.count = 4))
# Generates the direct search function
direct_search_method <- directSearchAlgorithm('selectKBest', list(k=2))
# Runs the direct feature selection process
res <- directFeatureSelection(mtcars, 'mpg', direct_search_method, filter_evaluator)


## Regression problem with wrapper

# Values for the caret trainControl function (resampling parameters)
resamplingParams <- list(method = "cv", repeats = 5)
# Values for the caret train function (fitting parameters)
fittingParams <- list(preProc = c("center", "scale"), metric="RMSE",
                      tuneGrid = expand.grid(k = c(1:12)))
# Generates the wraper evaluation function
wrapper_evaluator <- wrapperEvaluator('knn', resamplingParams, fittingParams)
# Generates the direct search function
direct_search_method <- directSearchAlgorithm('selectKBest',list(k=2))
# Runs the direct feature selection process
res <- directFeatureSelection(mtcars, 'mpg', direct_search_method, wrapper_evaluator)
}

}
\references{
\insertAllCited{}
}
\author{
Francisco Aragón Royón
}
