% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunLDA.R
\name{Predict}
\alias{Predict}
\title{Predict posterior probabilities for variants to be in 
each cluster in a fitted LDA model}
\usage{
Predict(predict.data, summary.c)
}
\arguments{
\item{predict.data}{A data frame with character-valued columns 
rs and cat and numeric-valued columns with annotations.
Each row contains data for one SNP in one tissue.
rs is an ID for the SNP, which need not be unique, and cat 
is an ID for each tissue, which must match an ID
for which training data was included when fitting the
LDA model. Aannotation columns must have column names matching
those supplied when fitting the LDA model.}

\item{summary.c}{A fitted LDA model created using 
\code{\link{FitLDAModel}} or \code{\link{FitLDAModelNewTissues}}.}
}
\value{
p.labeled, a data frame with one row per training variant
        with the posterior probability of each variant to be in each
        each cluster (with column names CLUSTER1,...) and columns
        cat and rs.
}
\description{
Predict posterior probabilities for variants to be in 
each cluster in a fitted LDA model
}
\examples{
\dontrun{
  data(training)
  summary.c <- FitLDAModel(training.data=training, nclust=3,
                         kde.nbins=100, iters=50, inner.iters=50)
  pred <- Predict(predict.data=training, summary.c=summary.c)
}
}
