% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/NHD_FUNCTIONS.R
\name{getNHD}
\alias{getNHD}
\title{Download and crop the National Hydrography Dataset.}
\usage{
getNHD(template, label, raw.dir = "./RAW/NHD/",
  extraction.dir = "./EXTRACTIONS/NHD/", force.redo = FALSE)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve
as a template for cropping.}

\item{label}{A character string naming the study area.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to "./RAW/NHD/".}

\item{extraction.dir}{A character string indicating where the extracted and cropped NHD shapefiles should be put.
The directory will be created if missing. Defaults to "./EXTRACTIONS/NHD/".}

\item{force.redo}{If an extraction for this template and label already exists, should a new one be created?}
}
\value{
A list of Spatial* objects extracted from the National Hydrography Dataset.
}
\description{
\code{getNHD} returns a list of Spatial* objects extracted
from the National Hydrography Dataset.
}

