% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/NHD_FUNCTIONS.R
\name{getNHDSubregion}
\alias{getNHDSubregion}
\title{Download and crop data from a zipped HUC4 subregion
of the National Hydrography Dataset.}
\usage{
getNHDSubregion(template = NULL, area, raw.dir)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve
as a template for cropping.}

\item{area}{A 4-character string indicating the HUC4 NHD subregion to download and crop.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing.}
}
\value{
A \code{SpatialPolygonsDataFrame} of the HUC4 regions within
the specified \code{template}.
}
\description{
\code{getNHDSubregion} returns a list of \code{SpatialPolygonsDataFrame}s of the layers of the HUC4 subregion,
 within the specified \code{template}. If template is not provided, returns the entire HUC4 subregion.
}

