% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsrk.R
\name{nsrk}
\alias{nsrk}
\title{Normal scale rule for kernel density estimation}
\usage{
nsrk(x, log_trsf=FALSE)
}
\arguments{
\item{x}{Univariate data.}

\item{log_trsf}{Logical flag: if \code{TRUE} the data are log-transformed (usually used for skewed positive data).
By default \code{log_trsf = FALSE}.}
}
\value{
The bandwidth value.
}
\description{
Bandwidth selector for non-parametric estimation. Estimates
the optimal AMISE bandwidth using the Normal Scale Rule with Gaussian kernel.
}
\examples{

x <- rnorm(1000)
h <- nsrk(x)

}
\references{
M. P. Wand and M. C. Jones,  (1995). Kernel Smoothing. Chapman and Hall, London.
}
