% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisout.R
\docType{class}
\name{FisOutFuzzy}
\alias{FisOutFuzzy}
\title{Class "FisOutFuzzy"}
\description{
Class to manage a \link{Fis} fuzzy output
}
\section{Fields}{

\describe{
\item{\code{defuzzification}}{\link{character} vector, The defuzzification operator of the fuzzy output\cr
Allowed values are: "sugeno" (the default) "MeanMax", or "area"\cr}

\item{\code{disjunction}}{\link{character} vector, The disjunction operator of the fuzzy output\cr
Allowed values are: "max" (the default) or "sum"\cr}
}}

\section{Inherits}{

\link{FisOutFuzzy} class inherits all fields and methods of \link{FisOut} class
}

\section{Constructors}{

\describe{
\item{\code{FisOutFuzzy()}}{
The default constructor to build a fuzzy output with the default range [0, 1]
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{FisOutFuzzy} object}
}}

\item{\code{FisOutFuzzy(minimum, maximum)}}{
The constructor to build a fuzzy output
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{minimum}}{\link{numeric} value, The minimum range value of the output}
\item{argument: \code{maximum}}{\link{numeric} value, The maximum range value of the output}
\item{return:}{\link{FisOutFuzzy} object}
}}

\item{\code{FisOutFuzzy(number_of_mfs, minimum, maximum)}}{
The constructor to build a fuzzy with a regular standardized fuzzy partition
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{number_of_mfs}}{\link{integer} value, The number of Mfs in the fuzzy partition}
\item{argument: \code{minimum}}{\link{numeric} value, The minimum range value of the output}
\item{argument: \code{maximum}}{\link{numeric} value, The maximum range value of the output}
\item{return:}{\link{FisOutFuzzy} object}
}}

\item{\code{FisOutFuzzy(breakpoints, minimum, maximum)}}{
The constructor to build a fuzzy with an irregular standardized fuzzy partition
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{breakpoints}}{\link{numeric} vector, The breakpoint values (sorted in ascending order) of the Mfs in the fuzzy partition}
\item{argument: \code{minimum}}{\link{numeric} value, The minimum range value of the output}
\item{argument: \code{maximum}}{\link{numeric} value, The maximum range value of the output}
\item{return:}{\link{FisOutFuzzy} object}
}}}
}

\section{Methods}{

\describe{
\item{\code{mf_size()}}{
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{integer} value, The number of Mfs in the output partition}
}}

\item{\code{add_mf(mf)}}{
Add an Mf in the output partition
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{mf}}{\link{Mf} object, The Mf to add}
}}

\item{\code{get_mf(mf_index)}}{
\if{latex}{\out{\hfill}}
\describe{
\item{argument: \code{mf_index}}{\link{integer} value, The index (1-based index) of the mf to return}
\item{return:}{\link{Mf} object}
}}

\item{\code{get_mfs()}}{
Get all mfs in the output
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{list} of \link{Mf} objects}
}}

\item{\code{is_standardized()}}{
\if{latex}{\out{\hfill}}
\describe{
\item{return:}{\link{logical} value, \code{TRUE} if the output is a standardized fuzzy partition, \code{FALSE} otherwise}
}}}
}

\examples{
output <- NewFisOutFuzzy(0, 2)
output$name <- "foo"
output$defuzzification <- "sugeno"
output$disjunction <- "max"
output$add_mf(NewMfTrapezoidalInf(0, 1))
output$add_mf(NewMfTriangular(0, 1, 2))
output$add_mf(NewMfTrapezoidalSup(1, 2))
}
\seealso{
{
\link{NewFisOutFuzzy}

\href{https://www.fispro.org/documentation/en/inline-help/node39.html}{Fuzzy Logic Elementary Glossary}
}
}
