% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot_plot.R
\encoding{UTF-8}
\name{dot_plot}
\alias{dot_plot}
\title{Dot-plot - Pacman-plot function}
\usage{
dot_plot(
  data.to.plot,
  size_var = NA,
  col_var = NA,
  text_var = NA,
  shape_var = 16,
  size_legend = "",
  col_legend = "",
  shape_legend = "",
  cols.use = "default",
  text.size = NA,
  text.vjust = 0,
  shape_use = "default",
  shape.scale = 12,
  scale.by = "radius",
  scale.min = NA,
  scale.max = NA,
  plot.legend = TRUE,
  do.return = FALSE,
  x.lab.rot = TRUE,
  x.lab.pos = c("both", "top", "bottom", "none"),
  y.lab.pos = c("left", "right", "both", "none"),
  x.lab.size.factor = 1,
  y.lab.size.factor = 1,
  vertical_coloring = NA,
  horizontal_coloring = NA,
  size.breaks.number = 4,
  color.breaks.number = 5,
  shape.breaks.number = 5,
  size.breaks.values = NA,
  color.breaks.values = NA,
  shape.breaks.values = NA,
  display_max_sizes = TRUE,
  transpose = FALSE,
  dend_x_var = NULL,
  dend_y_var = NULL,
  dist_method = c("euclidean", "maximum", "manhattan", "canberra", "binary",
    "minkowski"),
  hclust_method = c("ward.D", "single", "complete", "average", "mcquitty", "median",
    "centroid", "ward.D2"),
  do.plot = TRUE
)
}
\arguments{
\item{data.to.plot}{Input data. Can be a list or a data.frame.
If data.frame : Column 1 = x axis (Factor); Col2= y axis (Factor).
If list : x and y axis are fixed by row and col names of list elements.}

\item{size_var}{If numeric : Column/List index which control shape sizes. This column/element has to be numeric.
Can also be a column/element name or a vector of the same size than the input dataset.
Set to NA if you don't want to control shape size.}

\item{col_var}{If numeric : Column/List index which control shape colors.
Can also be a column/element name or a vector of the same size than the input dataset.
Set to NA if you don't want to control shape color.}

\item{text_var}{If numeric : Column/List index which control text to add on shapes.
Can also be a column/element name or a vector of the same size than the input dataset.
Set to NA if you don't want to add text.}

\item{shape_var}{If numeric = Similar to pch : square=15; circle=16; triangle=17. Can also be a column/element name or a vector of the same size than the input dataset.}

\item{size_legend}{Custom name of shape legend.}

\item{col_legend}{Custom name of shape color.}

\item{shape_legend}{Name of the shape legend if shape_var is a vector.}

\item{cols.use}{1 color or a vector containing multiple colors to color shapes.
If coloring is continuous, default colors are taken from a "lightgrey" to "blue" gradient.
If coloring is discrete, default colors are taken from the default ggplot2 palette.}

\item{text.size}{Size of text to display on the shapes.}

\item{text.vjust}{Vertical justification of text to display on the shapes. Default value = 0, which mean no justification. Recommended value is between -0.5 and 0.5.}

\item{shape_use}{Shapes to uses (only when shape is controled by a discrete factor). Default shapes : \\u25A0 \\u25CF \\u25C6 \\u2BC8 \\u2BC7 \\u2BC6 \\u2BC5 \\u25D8 \\u25D9 \\u2726  \\u2605 \\u2736 \\u2737.}

\item{shape.scale}{Scale the size of the shapes, similar to cex.}

\item{scale.by}{Scale the size by size or radius.}

\item{scale.min}{Set lower limit for scaling, use NA for default values.}

\item{scale.max}{Set upper limit for scaling, use NA for default values.}

\item{plot.legend}{Plot the legends ?}

\item{do.return}{Return ggplot2 object ?}

\item{x.lab.rot}{Rotate x-axis labels ?}

\item{x.lab.pos}{Where to display x axis labels. This must be one of "bottom","top","both" or "none".}

\item{y.lab.pos}{Where to display y axis labels. This must be one of "left","right","both"or "none".}

\item{x.lab.size.factor}{Factor resizing x-axis labels (default=1)}

\item{y.lab.size.factor}{Factor resizing y-axis labels (default=1)}

\item{vertical_coloring}{Which color use to color the plot vertically ? (colors are repeated untill the end of the plot). Setting vertical and horizontal coloring at the same time is not recommended !}

\item{horizontal_coloring}{Which color use to color the plot horizontally ? (colors are repeated untill the end of the plot). Setting vertical and horizontal coloring at the same time is not recommended !}

\item{size.breaks.number}{Number of shapes with different size to display in the legend. Not used if size.breaks.values is not NA.}

\item{color.breaks.number}{Number of labels for the color gradient legend. Not used if color.breaks.values is not NA.}

\item{shape.breaks.number}{Number of shapes to display in the legend. Used when shape is controled by a continuous factor only. Not used if shape.breaks.values is not NA.}

\item{size.breaks.values}{Vector containing numerical labels for the size legend.}

\item{color.breaks.values}{Vector containing numerical labels for continuous color legend.}

\item{shape.breaks.values}{Vector containing numerical labels for continuous shape legend.}

\item{display_max_sizes}{Boolean : Display max shape size behind each shape ? (Default=TRUE)}

\item{transpose}{Reverse x axis and y axis ?}

\item{dend_x_var}{A vector containing Column/List indexes or Column/List names to compute the x axis dendrogramm.}

\item{dend_y_var}{A vector containing Column/List indexes or Column/List names to compute the y axis dendrogramm.}

\item{dist_method}{The distance measure to be used. This must be one of "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski".}

\item{hclust_method}{The agglomeration method to be used. This must be one of "single", "complete", "average", "mcquitty", "ward.D", "ward.D2", "centroid" or "median".}

\item{do.plot}{Print the plot ? (default=TRUE)}
}
\value{
Print the plot (if do.plot=TRUE) and return a list containing input data, executed command, resulting dot plot and computed dendrograms (if do.return=TRUE)
}
\description{
Create dotplots to represent two discrete factors (x & y) described by several other factors. Each combination of the two discrete factors (x & y) can be described with : 1 continuous factor (setting shape size), 3 continuous or discrete factors (setting shape type, shape color and text on shape).
}
\examples{
library(FlexDotPlot)
data(CBMC8K_example_data)
dotplot = dot_plot(data.to.plot=CBMC8K_example_data, size_var="RNA.avg.exp.scaled",
col_var="ADT.avg.exp.scaled", text_var="ADT.pct.exp.sup.cutoff",
shape_var="canonical_marker", shape_use = c("\u25CF","\u2737"),x.lab.pos="bottom",
y.lab.pos="left", cols.use=c("lightgrey","orange","red", "darkred"),
size_legend="RNA", col_legend="ADT", shape_legend="Canonical marker ?",
shape.scale =12, text.size=3, plot.legend = TRUE,x.lab.rot = TRUE,
size.breaks.number=4, color.breaks.number=4, shape.breaks.number=5,
dend_x_var=c("RNA.avg.exp.scaled","ADT.avg.exp.scaled"),
dend_y_var=c("RNA.avg.exp.scaled","ADT.avg.exp.scaled"),
dist_method="euclidean",hclust_method="ward.D", do.return = TRUE)
}
\author{
Simon Leonard - simon.leonard@univ-rennes1.fr
}
