% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.cov.R
\name{pk.cov}
\alias{pk.cov}
\title{Center of Volume}
\usage{
pk.cov(TS)
}
\arguments{
\item{TS}{output from \code{\link{create.ts}} containing a data.frame of flow
time series}
}
\value{
Returns a data.frame with the following columns:
  \itemize{
    \item hYear - Hydrologic Years
    \item Q25 - day of hydrologic year for 25 percent of the total annual streamflow
    \item Q50 - day of hydrologic year for 50 percent of the total annual streamflow, i.e. Center of Volume
    \item Q75 - day of hydrologic year for 75 percent of the total annual streamflow
    \item Dur - duration of between the 25 percent and 75 percent day of year, in days
  }
}
\description{
This function calculates center of volume metrics, including the day of the 
hydrologic year that 25 percent, 50 percent, and 75 percent of the total annual 
streamflow is reached. A value of 0 is returned for years with no flow. Hydrologic 
years with fewer than normal observations (outliers) are excluded from the 
analysis, and for stations with seasonal flow records, additional seasonal 
subsetting is done to include only days with observations in all years.
}
\examples{
data(cania.sub.ts)
res1 <- pk.cov(cania.sub.ts)

# trend and changepoint plot for baseflow peak start doy
res2 <- screen.metric(res1[,2], "Day of Year")
}
\author{
Jennifer Dierauer
}

