% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.series.R
\name{screen.series}
\alias{screen.series}
\title{Create a plot of the daily streamflow time series}
\usage{
screen.series(TS, StnInfo = NULL, text = "d")
}
\arguments{
\item{TS}{output from \code{\link{create.ts}} containing a data.frame of flow
time series}

\item{StnInfo}{Optional data.frame containing user-supplied station info for plot. 
data.frame must have 7 columns containing station info in the following order:
Station ID, Station Name, Prov/State, Country, Latitude, Longitude, Catchment Area
If any of the information is unavailabe, fill with NA.  The Station ID column must
match the Station ID in column 1 of the data.frame input from \code{\link{create.ts}}.}

\item{text}{optional character string for margin text, e.g. for station name, 
location, or other notes. Set to NULL if not margin text is wanted, or set to "d" 
to use default text containing the station ID, station name, and province/state 
returned from \code{\link{station.info}}.}
}
\description{
Plots the daily streamflow time series and color codes points by data quality codes if 
the data are from Water Survey Canada. Also highlights date ranges with missing
observations.
}
\examples{
# load flow time series for the Caniapiscau River
data(cania.sub.ts)

# plot daily time series with default margin text
screen.series(cania.sub.ts)
}
\author{
Jennifer Dierauer and Paul Whitfield
}
