% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrink_estim.R
\name{shrink_estim}
\alias{shrink_estim}
\title{Shrinkage of the covariance matrix}
\usage{
shrink_estim(x, minT = T)
}
\arguments{
\item{x}{residual matrix}

\item{minT}{this param allows to calculate the covariance matrix according
to the original hts formulation (\code{TRUE}) or according to the standard
approach (\code{FALSE}).}
}
\value{
A list with two objects: the first (\code{$scov}) is the shrunk covariance matrix
and the second (\code{$lambda}) is the shrinkage intensity coefficient.
}
\description{
Shrinkage of the covariance matrix according to \enc{Schäfer}{Schafer} and Strimmer (2005).
}
\references{
\enc{Schäfer}{Schafer}, J.L., Strimmer, K. (2005), A Shrinkage Approach to Large-Scale Covariance Matrix
Estimation and Implications for Functional Genomics, \emph{Statistical Applications in Genetics
and Molecular Biology}, 4, 1

Hyndman, R. J., Lee, A., Wang, E., and Wickramasuriya, S. (2020).
hts: Hierarchical and Grouped Time Series, \emph{R package version 6.0.1},
\href{https://CRAN.R-project.org/package=hts}{https://CRAN.R-project.org/package=hts}.
}
\seealso{
Other utilities: 
\code{\link{Cmatrix}()},
\code{\link{FoReco2ts}()},
\code{\link{agg_ts}()},
\code{\link{arrange_hres}()},
\code{\link{commat}()},
\code{\link{ctf_tools}()},
\code{\link{hts_tools}()},
\code{\link{lcmat}()},
\code{\link{oct_bounds}()},
\code{\link{residuals_matrix}()},
\code{\link{score_index}()},
\code{\link{thf_tools}()}
}
\author{
This function is a modified version of the \code{shrink_estim}() hidden function of \pkg{hts}.
}
\concept{utilities}
\keyword{utilities}
