% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_export.R
\name{FoReco2matrix}
\alias{FoReco2matrix}
\title{Reconciled forecasts to matrix/vector}
\usage{
FoReco2matrix(x, agg_order, keep_names = FALSE)
}
\arguments{
\item{x}{An output from any reconciliation function implemented by \pkg{FoReco}.}

\item{agg_order}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \eqn{m}), or a vector representing a subset of \eqn{p} factors
of \eqn{m}.}

\item{keep_names}{If \code{FALSE} (\emph{default}), the rownames names of the output matrices are removed.}
}
\value{
A list of matrices or vectors distinct by temporal aggregation order.
}
\description{
This function splits the temporal vectors and the cross-temporal matrices in a
list according to the temporal aggregation order
}
\examples{
set.seed(123)
# (3 x 7) base forecasts matrix (simulated), Z = X + Y and m = 4
base <- rbind(rnorm(7, rep(c(20, 10, 5), c(1, 2, 4))),
              rnorm(7, rep(c(10, 5, 2.5), c(1, 2, 4))),
              rnorm(7, rep(c(10, 5, 2.5), c(1, 2, 4))))

reco <- ctrec(base = base, agg_mat = t(c(1,1)), agg_order = 4, comb = "ols")
matrix_list <- FoReco2matrix(reco)
}
\seealso{
Utilities: 
\code{\link{aggts}()},
\code{\link{balance_hierarchy}()},
\code{\link{commat}()},
\code{\link{csprojmat}()},
\code{\link{cstools}()},
\code{\link{ctprojmat}()},
\code{\link{cttools}()},
\code{\link{df2aggmat}()},
\code{\link{lcmat}()},
\code{\link{recoinfo}()},
\code{\link{res2matrix}()},
\code{\link{shrink_estim}()},
\code{\link{teprojmat}()},
\code{\link{tetools}()},
\code{\link{unbalance_hierarchy}()}
}
\concept{Utilities}
