% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAtree.R
\name{SAtree.from.fossils}
\alias{SAtree.from.fossils}
\title{Transforms a tree and fossils dataframe to a combined SA tree.
Sampled ancestors are represented as tips on zero-length edges to maintain compatibility with the ape format.}
\usage{
SAtree.from.fossils(tree, fossils)
}
\arguments{
\item{tree}{Phylo object.}

\item{fossils}{Fossils object.}
}
\value{
A tree integrating the fossils.
}
\description{
Transforms a tree and fossils dataframe to a combined SA tree.
Sampled ancestors are represented as tips on zero-length edges to maintain compatibility with the ape format.
}
\examples{
# simulate tree
t = ape::rtree(6)

# simulate fossils
f = sim.fossils.poisson(rate = 2, tree = t)

# transform format
t2 = SAtree.from.fossils(t,f)
plot(t2)
}
