% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImputationDimp.R
\name{ImputationDimp}
\alias{ImputationDimp}
\title{DIMP (d-imputation) method for fuzzy numbers.}
\usage{
ImputationDimp(dataToImpute, trapezoidal = TRUE, ...)
}
\arguments{
\item{dataToImpute}{Name of the input matrix (data frame or list) of fuzzy numbers with some NAs.}

\item{trapezoidal}{Logical value depending on the type of fuzzy values (triangular or trapezoidal ones) in the dataset.}

\item{...}{Additional parameters passed to other functions}
}
\value{
The output is given as a matrix.
}
\description{
`ImputationDimp` imputes (i.e., replaces missing values) fuzzy numbers using the DIMP (d-imputation) method.
}
\details{
The procedure randomly imputes missing values (NAs) with suitable data in the case of the dataset (or matrix, or list)
consisting of fuzzy numbers (triangular fuzzy numbers if \code{trapezoidal=FALSE} is set, or trapezoidal if the default
\code{trapezoidal=TRUE} is used).
The output is given as a matrix without NAs, where each row is related to fuzzy numbers (given by 3 values for the triangular fuzzy numbers,
or 4 values in the case of trapezoidal ones) for the consecutive variables.
Many fuzzy variables (not the only one) can be used. 
The input has to consist of fuzzy numbers of the same types (i.e., mixing triangular and trapezoidal fuzzy numbers is not allowed).
}
\examples{



# seed PRNG

set.seed(1234)

# load the necessary library

library(FuzzySimRes)

# generate sample of trapezoidal fuzzy numbers with FuzzySimRes library

list1<-SimulateSample(20,originalPD="rnorm",parOriginalPD=list(mean=0,sd=1),
incrCorePD="rexp", parIncrCorePD=list(rate=2),
suppLeftPD="runif",parSuppLeftPD=list(min=0,max=0.6),
suppRightPD="runif", parSuppRightPD=list(min=0,max=0.6),
type="trapezoidal")

# convert fuzzy data into a matrix

matrix1 <- FuzzyNumbersToMatrix(list1$value)

# check starting values

head(matrix1)

# add some NAs to the matrix

matrix1NA <- IntroducingNA(matrix1,percentage = 0.1)

head(matrix1NA)

# impute missing values

ImputationDimp(matrix1NA)


}
