% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omni_ss.R
\name{OMNI_ss}
\alias{OMNI_ss}
\title{omni_ss.R}
\usage{
OMNI_ss(test_stats, cor_mat, num_boots = 100)
}
\arguments{
\item{test_stats}{Vector of test statistics for each factor in the set (i.e. marginal
test statistic for each SNP in a gene)}

\item{cor_mat}{d*d matrix of the correlations between all the test statistics in
the set, where d is the total number of test statistics in the set.}

\item{num_boots}{Number of bootstrap repetitions to find correlation matrix of set-based statistics.}
}
\value{
A list with the elements:
\item{OMNI}{The observed omnibus test statistic.}
\item{OMNI_pvalue}{The p-value of the OMNI test}
\item{err_code}{Sometimes if your p-value is very small (< 1*10^(-10)), R may run into numerical
issues. This message will alert you if such a situation occurs.}
}
\description{
Computes the omnibus test statistic combining GBJ, GHC, minP, and SKAT.
This version of the function assumes you are using GWAS summary statistics.
If you individual-level genotype data, use omni_individual().
}
\examples{
cor_mat <- matrix(data=0.3, nrow=5, ncol=5)
diag(cor_mat) <- 1
test_stats <- as.numeric(mvtnorm::rmvnorm(n=1, sigma=cor_mat))
OMNI_ss(test_stats=test_stats, cor_mat=cor_mat, num_boots=5)
}

