% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportedFuncs.R
\name{attributepattern}
\alias{attributepattern}
\title{Generate all possible attribute patterns}
\usage{
attributepattern(K, Q)
}
\arguments{
\item{K}{number of attributes}

\item{Q}{Q-matrix; required when Q-matrix is polytomous}
}
\value{
A \eqn{2^K\times K} matrix consisting of attribute profiles for \eqn{2^K} latent classes
}
\description{
This function generates all possible attribute patterns. The Q-matrix needs to be specified for polytomous attributes.
}
\examples{
attributepattern(3)

q <- matrix(scan(text = "0 1 2 1 0 1 1 2 0"),ncol = 3)
q
attributepattern(Q=q)

q <- matrix(scan(text = "0 1 1 1 0 1 1 1 0"),ncol = 3)
q
attributepattern(K=ncol(q),Q=q)
}
\author{
{Wenchao Ma, The University of Alabama, \email{wenchao.ma@ua.edu} \cr Jimmy de la Torre, The University of Hong Kong}
}
