% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sserr.R
\name{sserr}
\alias{sserr}
\title{Compute the Return Rate in the Steady State Equilibrium}
\usage{
sserr(eis, rho.beta, gr = 0, type = "CES", prepaid = FALSE)
}
\arguments{
\item{eis}{a positive scalar indicating the elasticity of intertemporal substitution in the intertemporal utility function.}

\item{rho.beta}{a positive scalar indicating the subjective discount factor, which is typically no greater than 1.}

\item{gr}{a non-negative scalar indicating the growth rate in the steady state equilibrium.}

\item{type}{a character indicating the type of the intertemporal utility function, which may be CES (i.e. CRRA) or SCES.}

\item{prepaid}{a logical value. If prepaid is FALSE, the return rate is returned.
Otherwise the prepaid steady-state equilibrium return rate (i.e. the prepaid yield) is returned.}
}
\description{
Compute the (postpaid) return rate in the steady state equilibrium.
}
\examples{
\donttest{
sserr(eis = 1, rho.beta = 0.97, gr = 0)
sserr(eis = 1, rho.beta = 1.25, gr = 0)
sserr(eis = 1, rho.beta = 0.97, gr = 0, type = "SCES")

sserr(eis = 0.5, rho.beta = 0.97, gr = 0)
sserr(eis = 0.5, rho.beta = 0.97, gr = 0, type = "SCES")
}

}
