% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.oGFisher.R
\name{p.oGFisher}
\alias{p.oGFisher}
\title{P-value of the omnibus generalized Fisher's p-value combination test.}
\usage{
p.oGFisher(p, DF, W, M, p.type = "two", method = "HYB",
  combine = "cct", nsim = NULL, seed = NULL)
}
\arguments{
\item{p}{- vector of input p-values.}

\item{DF}{- matrix of degrees of freedom for inverse chi-square transformation for each p-value. Each row represents a GFisher test.}

\item{W}{- matrix of weights. Each row represents a GFisher test.}

\item{M}{- correlation matrix of the input statistics.}

\item{p.type}{- "two" = two-sided p-values, "one" = one-sided p-values.}

\item{method}{- "MR" = simulation-assisted moment ratio matching, "HYB" = moment ratio matching by quadratic approximation, "GB" = Brown's method with calculated variance. See details in the reference.}

\item{combine}{- "cct" = oGFisher using the Cauchy combination method, "mvn" = oGFisher using multivariate normal distribution.}

\item{nsim}{- number of simulation used in the "MR" method, default = 5e4.}

\item{seed}{- random seed used in the "MR" method}
}
\value{
1. p-value of the oGFisher test. 2. individual p-value of each GFisher test.
}
\description{
P-value of the omnibus generalized Fisher's p-value combination test.
}
\examples{
set.seed(123)
n = 10
M = matrix(0.3, n, n) + diag(0.7, n, n)
zscore = matrix(rnorm(n),nrow=1)\%*\%chol(M)
pval = 2*(1-pnorm(abs(zscore)))
DF = rbind(rep(1,n),rep(2,n))
W = rbind(rep(1,n), 1:10)
p.oGFisher(pval, DF, W, M, p.type="two", method="HYB", combine="cct")
}
\references{
Hong Zhang and Zheyang Wu. "Accurate p-Value Calculation for Generalized Fisher's Combination Tests Under Dependence", <arXiv:2003.01286>.
}
