% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggnostic.R
\name{ggally_nostic_std_resid}
\alias{ggally_nostic_std_resid}
\title{\code{\link{ggnostic}} standardized residuals}
\usage{
ggally_nostic_std_resid(data, mapping, ..., sigma = 1)
}
\arguments{
\item{data, mapping, ...}{parameters supplied to \code{\link{ggally_nostic_resid}}}

\item{sigma}{sigma value for the \code{pVal} percentiles. Set to 1 for standardized residuals}
}
\value{
\pkg{ggplot2} plot object
}
\description{
If non-null \code{pVal} and \code{sigma} values are given, confidence interval lines will be added to the plot at the specified \code{pVal} locations of a N(0, 1) distribution.
}
\examples{
# Small function to display plots only if it's interactive
p_ <- GGally::print_if_interactive

dt <- broomify(stats::lm(mpg ~ wt + qsec + am, data = mtcars))
p_(ggally_nostic_std_resid(dt, ggplot2::aes(wt, .std.resid)))
}
\seealso{
\code{stats::\link[stats]{rstandard}}
}
