% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amp_acro.R
\name{amp_acro}
\alias{amp_acro}
\title{Used to specify a cosinor component in the model formula.}
\usage{
amp_acro(time_col, n_components = 1, group, period, ...)
}
\arguments{
\item{time_col}{A  \code{numeric} column within the \code{data.frame()}
passed by via the \code{data} arg containing the time values.}

\item{n_components}{The Number of cosinor components in the model.}

\item{group}{A vector of the names for the group factors (column names
within the \code{data.frame()} passed by via the \code{data} arg).}

\item{period}{A \code{numeric} value or vector containing the period.
The number of values should be equal to \code{n_components}.}

\item{...}{Extra arguments for use within \code{GLMMcosinor}.}
}
\value{
A \code{data.frame} and \code{formula} appropriate for use by
\code{data_processor()}.
}
\description{
Checks the validity of user inputs before creating an updated formula
and associated modifications to the \code{data.frame}.
}
\examples{
# Single component cosinor model
cglmm(
  vit_d ~ amp_acro(time_col = time, group = "X", period = 12),
  data = vitamind
)

# 2-component cosinor model with simulated data
sim_data <- simulate_cosinor(
  n = 500,
  mesor = 5,
  amp = c(2, 1),
  acro = c(1, 1.5),
  beta.mesor = 2,
  beta.amp = c(2, 1),
  beta.acro = c(1, 1.5),
  family = "gaussian",
  period = c(12, 6),
  n_components = 2,
  beta.group = TRUE,
)

cglmm(
  Y ~ group + amp_acro(times,
    n_components = 2,
    group = "group",
    period = c(12, 6)
  ),
  data = sim_data,
  family = gaussian
)
}
