% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmse_summary.R
\name{gmse_table}
\alias{gmse_table}
\title{GMSE table results}
\usage{
gmse_table(gmse_sim, hide_unused_options = TRUE, all_time = TRUE)
}
\arguments{
\item{gmse_sim}{The output of a `gmse` simulation.}

\item{hide_unused_options}{Whether or not to hide results from policy options when creating the resulting table. If `TRUE` (default), then policy and user actions that are not allowed in a simulation will not be placed as columns. If `FALSE`, then these columns will be placed with values of `NA`.}

\item{all_time}{Whether or not results from each time step from the simulation should be individually placed as a row in the resulting table (`TRUE` by default). If `FALSE`, then only the last row will be placed.}
}
\value{
A table with one or more rows of results, each of which indicates a unique `gmse` simulation for a given time step. Columns represent key simulation including resource densities, observation estimates, policy, and user actions.
}
\description{
The gmse_table function takes results created from simulations of the gmse
and concatenates key results from a large list into a more manageable data 
table.
}
\examples{
sim       <- gmse(time_max = 10);
sim_table <- gmse_table(gmse_sim = sim);
}
