% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmse_replicates.R
\name{gmse_replicates}
\alias{gmse_replicates}
\title{gmse replicate simulations}
\usage{
gmse_replicates(replicates, all_time = FALSE, hide_unused_options = TRUE, ...)
}
\arguments{
\item{replicates}{The number of replicate simulations to be run}

\item{all_time}{Passes to gmse_table. If TRUE, then results from all time steps of the simulation are returned; if FALSE (default), then only results from the last time step of each simulation is returned.}

\item{hide_unused_options}{Passes to gmse_table. If TRUE (default), then action options (e.g., scaring, culling, etc.) that are not available are not included in the results summary. If FALSE, then they are included as `NA`}

\item{...}{Parameter values to be passed to the gmse function}
}
\value{
A simplified list that includes four elements, each of which is a table of data: 1. resources, a table showing time step in the first column, followed by resource abundance in the second column. 2. observations, a table showing time step in the first column, followed by the estimate of population size (produced by the manager) in the second column. 3. costs, a table showing time step in the first column, manager number in the second column (should always be zero), followed by the costs of each action set by the manager (policy); the far-right column indicates budget that is unused and therefore not allocated to any policy. 4. actions, a table showing time step in the first column, user number in the second column, followed by the actions of each user in the time step; additional columns indicate unused actions, crop yield on the user's land (if applicable), and the number of resources that a user successfully harvests (i.e., 'culls').
}
\description{
Replicates the same simulation for a set of parameter values
}
\examples{
\dontrun{
sim_replicates <- gmse_replicates(replicates = 2, time_max = 5);
}
}
