% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_optimal_nn.R
\name{find_optimal_nn}
\alias{find_optimal_nn}
\title{Find the optimal hyper-parameter for the nearest neighbor Gaussian process}
\usage{
find_optimal_nn(
  w_obs,
  w,
  y_obs,
  gps_m,
  design_mt,
  hyperparams = expand.grid(seq(0.5, 4.5, 1), seq(0.5, 4.5, 1), seq(0.5, 4.5, 1)),
  kernel_fn = function(x) exp(-x^2),
  n_neighbor = 50,
  block_size = 2000,
  nthread = 1
)
}
\arguments{
\item{w_obs}{A vector of the observed exposure levels.}

\item{w}{A vector of exposure levels at which CERF will be estimated.}

\item{y_obs}{A vector of observed outcomes}

\item{gps_m}{An S3 gps object including:
gps: A data.frame of GPS vectors.
- Column 1: GPS
- Column 2: Prediction of exposure for covariate of each data sample
(e_gps_pred).
- Column 3: Standard deviation of  e_gps (e_gps_std)
used_params:
- dnorm_log: TRUE or FLASE}

\item{design_mt}{The covariate matrix of all samples (intercept excluded).}

\item{hyperparams}{A matrix of candidate values of the hyper-parameters,
each row contains a set of values of all hyper-parameters.}

\item{kernel_fn}{The covariance function of the GP.}

\item{n_neighbor}{The number of nearest neighbors on one side.}

\item{block_size}{The number of samples included in a computation block.
Mainly used to balance the speed and memory requirement. Larger
\code{block_size} is faster, but requires more memory.}

\item{nthread}{An integer value that represents the number of threads to be
used by internal packages.}
}
\value{
Estimated covariate balance scores for the grid of hyper-parameter values
considered in \code{hyperparams}.
}
\description{
Computes covariate balance for each combination of provided hyper-parameters
and selects the hyper-parameter values that minimizes the covariate balance.
}
\keyword{internal}
