% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_tximport.R
\name{run_tximport}
\alias{run_tximport}
\title{Wrapper function to run tximport}
\usage{
run_tximport(srr_id, species = c("human", "mouse", "rat"), salmon_dir,
  countsFromAbundance = c("no", "scaledTPM", "lengthScaledTPM"))
}
\arguments{
\item{srr_id}{SRA run accession ID.}

\item{species}{name of the species. Only \code{'human'}, \code{'mouse'},
and \code{'rat'} are allowed to use.}

\item{salmon_dir}{directory where salmon files are saved. This should be 
the folder created by Salmon and is called "salmon".}

\item{countsFromAbundance}{whether to generate counts based on abundance.
Available options are: \code{'no'}, 
\code{'scaledTPM'} (abundance based estimated counts scaled up to
library size), 
\code{'lengthScaledTPM'} (default, scaled using the average transcript
length over samples and library size).}
}
\value{
a list of gene and transcript level estimated counts.
}
\description{
\code{run_tximport} function runs tximport on transcript level
abundances from Salmon to summarize to gene level. See Bioconductor
package \link[tximport]{tximport} for details.
}
\details{
We use Ensembl annotation for both genes and transcripts.
}
\examples{

#Run this function after running Salmon.
salmon_dir=system.file("extdata","", package="GREP2")
run_tximport(srr_id="SRR5890521", species="human",
salmon_dir=salmon_dir,countsFromAbundance="lengthScaledTPM")

}
\references{
Charlotte Soneson, Michael I. Love, Mark D. Robinson (2015):
Differential analyses for RNA-seq: transcript-level estimates
improve gene-level inferences. F1000Research.
\url{http://dx.doi.org/10.12688/f1000research.7563.1}
}
