% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GauPro_Gauss_LOO.R
\docType{class}
\name{GauPro_Gauss_LOO}
\alias{GauPro_Gauss_LOO}
\title{Corr Gauss GP using inherited optim}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} with methods for fitting GP model.
}
\description{
Corr Gauss GP using inherited optim

Corr Gauss GP using inherited optim
}
\examples{
n <- 12
x <- matrix(seq(0,1,length.out = n), ncol=1)
y <- sin(2*pi*x) + rnorm(n,0,1e-1)
gp <- GauPro_Gauss_LOO$new(X=x, Z=y, parallel=FALSE)
}
\section{Super classes}{
\code{\link[GauPro:GauPro]{GauPro::GauPro}} -> \code{\link[GauPro:GauPro_Gauss]{GauPro::GauPro_Gauss}} -> \code{GauPro_Gauss_LOO}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-update}{\code{GauPro_Gauss_LOO$update()}}
\item \href{#method-pred_one_matrix}{\code{GauPro_Gauss_LOO$pred_one_matrix()}}
\item \href{#method-clone}{\code{GauPro_Gauss_LOO$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="cool1Dplot">}\href{../../GauPro/html/GauPro.html#method-cool1Dplot}{\code{GauPro::GauPro$cool1Dplot()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="deviance_searchnug">}\href{../../GauPro/html/GauPro.html#method-deviance_searchnug}{\code{GauPro::GauPro$deviance_searchnug()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="fit">}\href{../../GauPro/html/GauPro.html#method-fit}{\code{GauPro::GauPro$fit()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="grad_norm">}\href{../../GauPro/html/GauPro.html#method-grad_norm}{\code{GauPro::GauPro$grad_norm()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="initialize_GauPr">}\href{../../GauPro/html/GauPro.html#method-initialize_GauPr}{\code{GauPro::GauPro$initialize_GauPr()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="loglikelihood">}\href{../../GauPro/html/GauPro.html#method-loglikelihood}{\code{GauPro::GauPro$loglikelihood()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="nugget_update">}\href{../../GauPro/html/GauPro.html#method-nugget_update}{\code{GauPro::GauPro$nugget_update()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="optim">}\href{../../GauPro/html/GauPro.html#method-optim}{\code{GauPro::GauPro$optim()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="optimRestart">}\href{../../GauPro/html/GauPro.html#method-optimRestart}{\code{GauPro::GauPro$optimRestart()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="plot1D">}\href{../../GauPro/html/GauPro.html#method-plot1D}{\code{GauPro::GauPro$plot1D()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="plot2D">}\href{../../GauPro/html/GauPro.html#method-plot2D}{\code{GauPro::GauPro$plot2D()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred">}\href{../../GauPro/html/GauPro.html#method-pred}{\code{GauPro::GauPro$pred()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_LOO">}\href{../../GauPro/html/GauPro.html#method-pred_LOO}{\code{GauPro::GauPro$pred_LOO()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_mean">}\href{../../GauPro/html/GauPro.html#method-pred_mean}{\code{GauPro::GauPro$pred_mean()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_meanC">}\href{../../GauPro/html/GauPro.html#method-pred_meanC}{\code{GauPro::GauPro$pred_meanC()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="pred_var">}\href{../../GauPro/html/GauPro.html#method-pred_var}{\code{GauPro::GauPro$pred_var()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="predict">}\href{../../GauPro/html/GauPro.html#method-predict}{\code{GauPro::GauPro$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="sample">}\href{../../GauPro/html/GauPro.html#method-sample}{\code{GauPro::GauPro$sample()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_K_and_estimates">}\href{../../GauPro/html/GauPro.html#method-update_K_and_estimates}{\code{GauPro::GauPro$update_K_and_estimates()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_corrparams">}\href{../../GauPro/html/GauPro.html#method-update_corrparams}{\code{GauPro::GauPro$update_corrparams()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_data">}\href{../../GauPro/html/GauPro.html#method-update_data}{\code{GauPro::GauPro$update_data()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro" data-id="update_nugget">}\href{../../GauPro/html/GauPro.html#method-update_nugget}{\code{GauPro::GauPro$update_nugget()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="corr_func">}\href{../../GauPro/html/GauPro_Gauss.html#method-corr_func}{\code{GauPro::GauPro_Gauss$corr_func()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance">}\href{../../GauPro/html/GauPro_Gauss.html#method-deviance}{\code{GauPro::GauPro_Gauss$deviance()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_fngr">}\href{../../GauPro/html/GauPro_Gauss.html#method-deviance_fngr}{\code{GauPro::GauPro_Gauss$deviance_fngr()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_grad">}\href{../../GauPro/html/GauPro_Gauss.html#method-deviance_grad}{\code{GauPro::GauPro_Gauss$deviance_grad()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_log">}\href{../../GauPro/html/GauPro_Gauss.html#method-deviance_log}{\code{GauPro::GauPro_Gauss$deviance_log()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_log2">}\href{../../GauPro/html/GauPro_Gauss.html#method-deviance_log2}{\code{GauPro::GauPro_Gauss$deviance_log2()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_log2_fngr">}\href{../../GauPro/html/GauPro_Gauss.html#method-deviance_log2_fngr}{\code{GauPro::GauPro_Gauss$deviance_log2_fngr()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_log2_grad">}\href{../../GauPro/html/GauPro_Gauss.html#method-deviance_log2_grad}{\code{GauPro::GauPro_Gauss$deviance_log2_grad()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_log_grad">}\href{../../GauPro/html/GauPro_Gauss.html#method-deviance_log_grad}{\code{GauPro::GauPro_Gauss$deviance_log_grad()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_theta">}\href{../../GauPro/html/GauPro_Gauss.html#method-deviance_theta}{\code{GauPro::GauPro_Gauss$deviance_theta()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="deviance_theta_log">}\href{../../GauPro/html/GauPro_Gauss.html#method-deviance_theta_log}{\code{GauPro::GauPro_Gauss$deviance_theta_log()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="get_optim_functions">}\href{../../GauPro/html/GauPro_Gauss.html#method-get_optim_functions}{\code{GauPro::GauPro_Gauss$get_optim_functions()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="grad">}\href{../../GauPro/html/GauPro_Gauss.html#method-grad}{\code{GauPro::GauPro_Gauss$grad()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="grad_dist">}\href{../../GauPro/html/GauPro_Gauss.html#method-grad_dist}{\code{GauPro::GauPro_Gauss$grad_dist()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="hessian">}\href{../../GauPro/html/GauPro_Gauss.html#method-hessian}{\code{GauPro::GauPro_Gauss$hessian()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="initialize">}\href{../../GauPro/html/GauPro_Gauss.html#method-initialize}{\code{GauPro::GauPro_Gauss$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="param_optim_jitter">}\href{../../GauPro/html/GauPro_Gauss.html#method-param_optim_jitter}{\code{GauPro::GauPro_Gauss$param_optim_jitter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="param_optim_lower">}\href{../../GauPro/html/GauPro_Gauss.html#method-param_optim_lower}{\code{GauPro::GauPro_Gauss$param_optim_lower()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="param_optim_start">}\href{../../GauPro/html/GauPro_Gauss.html#method-param_optim_start}{\code{GauPro::GauPro_Gauss$param_optim_start()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="param_optim_start0">}\href{../../GauPro/html/GauPro_Gauss.html#method-param_optim_start0}{\code{GauPro::GauPro_Gauss$param_optim_start0()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="param_optim_upper">}\href{../../GauPro/html/GauPro_Gauss.html#method-param_optim_upper}{\code{GauPro::GauPro_Gauss$param_optim_upper()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="print">}\href{../../GauPro/html/GauPro_Gauss.html#method-print}{\code{GauPro::GauPro_Gauss$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="GauPro" data-topic="GauPro_Gauss" data-id="update_params">}\href{../../GauPro/html/GauPro_Gauss.html#method-update_params}{\code{GauPro::GauPro_Gauss$update_params()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update"></a>}}
\if{latex}{\out{\hypertarget{method-update}{}}}
\subsection{Method \code{update()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss_LOO$update(
  Xnew = NULL,
  Znew = NULL,
  Xall = NULL,
  Zall = NULL,
  restarts = 5,
  param_update = self$param.est,
  nug.update = self$nug.est,
  no_update = FALSE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pred_one_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-pred_one_matrix}{}}}
\subsection{Method \code{pred_one_matrix()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss_LOO$pred_one_matrix(XX, se.fit = F, covmat = F)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GauPro_Gauss_LOO$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
