% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{combine_trees}
\alias{combine_trees}
\title{Get consensus tree between two phylogenetic trees}
\usage{
combine_trees(
  phylotree_1,
  phylotree_2,
  palette = GeRnika::palettes$Simpsons,
  labels = FALSE
)
}
\arguments{
\item{phylotree_1}{A \code{Phylotree} class object.}

\item{phylotree_2}{A \code{Phylotree} class object.}

\item{palette}{A vector composed by the hexadecimal code of three colors. "The Simpsons" palette used as default.}

\item{labels}{A boolean, if \code{TRUE} the resulting graph will be plotted with the tags of the genes in the phylogenetic trees instead of their mutation index. \code{FALSE} by default.}
}
\value{
a \code{dgr_graph} object representing the consensus graph between \code{phylotree_1} \code{phylotree_2}.
}
\description{
Returns a graph representing the consensus tree between two phylogenetic trees.
}
\examples{

# Load the predefined B matrices of the package
B_mats <- GeRnika::B_mats


B_real <- B_mats[[2]]$B_real
B_opt <- B_mats[[2]]$B_opt


# Generate the tags for the genes of
# the phyogenetic tree
tags <- LETTERS[1:nrow(B_real)]


# Instantiate two \code{Phylotree} class objects on 
# the basis of the B matrices
phylotree_real <- B_to_phylotree(
                    B = B_real, 
                    labels = tags)
                    
phylotree_opt <- B_to_phylotree(
                    B = B_opt, 
                    labels = tags)


# Create the consensus tree between phylotree_real
# and phylotree_opt
consensus <- combine_trees(
               phylotree_1 = phylotree_real,
               phylotree_2 = phylotree_opt)
               
               
# Render the consensus tree
DiagrammeR::render_graph(consensus)


# Load another palette
palette_1 <- GeRnika::palettes$Lancet


# Create the consensus tree between phylotree_real
# and phylotree_opt using tags and another palette
consensus_tag <- combine_trees(
                   phylotree_1 = phylotree_real, 
                   phylotree_2 = phylotree_opt,
                   palette = palette_1,
                   labels = TRUE)


# Render the consensus tree using tags and the
# selected palette
DiagrammeR::render_graph(consensus_tag)
}
