% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect.genai.R
\name{connect.genai}
\alias{connect.genai}
\title{Set up and connect to a Generative AI model}
\usage{
connect.genai(provider, model, version, api, proxy = FALSE)
}
\arguments{
\item{provider}{A character string representing the Generative AI service provider
(e.g., \code{"google"}, \code{"openai"}).}

\item{model}{A character string representing the specific model offered by the selected
provider (e.g., \code{"gpt-3.5-turbo"}, \code{"gemini-pro"}).}

\item{version}{A character string representing the version of the chosen model.}

\item{api}{A character string representing the API key required for accessing the model.}

\item{proxy}{A boolean value indicating whether to use a proxy for accessing the API
URL (default is \code{FALSE}). If your local internet cannot access the APIs, set this
parameter to \code{TRUE}.}
}
\value{
If successful, the function returns a vector containing information about the
chosen Generative AI service provider, model, version, API key, and proxy status.
If the API response indicates an error, the function halts execution and provides
an error message.
}
\description{
This function establishes a connection to a Generative AI model by providing essential
parameters such as the service provider, model, version, API key, and proxy status.
}
\details{
It is crucial to provide accurate and valid information for each parameter
to ensure a successful connection to the Generative AI model. If any of the provided
parameters are incorrect, the function will respond with an error message based on
the information received from the API. Use the function \code{\link{available.models}} to
see all supported Generative AI models.
}
\examples{
\dontrun{
 # Get available models
 models = available.models()

 # Connect to the model, replace API_KEY with your api key
 google.model = connect.genai("google",
                              models$google$model[1],
                              models$google$version[1],
                              "API_KEY",
                              FALSE)
 google.model

 # Connect to the model, replace API_KEY with your api key
 openai.model = connect.genai("openai",
                              models$openai$model[1],
                              models$openai$version[1],
                              "API_KEY",
                              FALSE)
 openai.model
}

}
\seealso{
\href{https://genai.gd.edu.kg/r/documentation/}{GenAI - R Documentation}

\href{https://genai.gd.edu.kg/#api-proxy-service}{GenAI - API Proxy Service}
}
