% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GeoLight.R
\name{distanceFilter}
\alias{distanceFilter}
\title{Filter for unrealistic positions within a track based on distance}
\usage{
distanceFilter(tFirst, tSecond, type, twl, degElevation = -6, distance,
  units = "hour")
}
\arguments{
\item{tFirst}{vector of sunrise/sunset times (e.g. 2008-12-01 08:30).}

\item{tSecond}{vector of of sunrise/sunset times (e.g. 2008-12-01 17:30).}

\item{type}{vector of either 1 or 2, defining \code{tFirst} as sunrise or sunset respectively.}

\item{twl}{data.frame containing twilights and at least \code{tFirst}, \code{tSecond} and \code{type} (alternatively give each parameter separately).}

\item{degElevation}{sun elevation angle in degrees (e.g. -6 for "civil
twilight")}

\item{distance}{the maximal distance in km per \code{units}. Distances above
will be considered as unrealistic.}

\item{units}{the time unite corresponding to the distance. Default is
"hour", alternative option is "day".}
}
\value{
Logical \code{vector}. TRUE means the particular position passed the filter.
}
\description{
The filter identifies unrealistic positions. The maximal distance per
hour/day can be set corresponding to the particular species.
}
\details{
Note that this type of filter significantly depends on the calibration
(\code{degElevation}). Especially during equinox periods. In contrast, the
(\code{loessFilter}) is independent from positions (uses twilight times)
and therefore superior.
}
\author{
Simeon Lisovski, Fraenzi Korner-Nievergelt
}

