% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssa.btl.diag.R
\name{ssa.btl.diag}
\alias{ssa.btl.diag}
\title{Binomial tau-leap method (BTL) for nu-diagonalized systems}
\usage{
ssa.btl.diag(x, a, nu_tile, f)
}
\arguments{
\item{x}{state vector.}

\item{a}{vector of evaluated propensity functions.}

\item{nu_tile}{state-change matrix.}

\item{f}{coarse-graining factor (see page 4 in Chatterjee et al. 2005).}
}
\value{
A list with two elements:
\itemize{
\item the time leap (\code{tau}) and
\item the realized state change vector (\code{nu_j}).
}
}
\description{
Binomial tau-leap method for nu-diagonalized systems
}
\details{
Performs one time step using the Binomial tau-leap method. It is usually
called from within \code{\link[=ssa]{ssa()}}, but can be invoked directly, see
\code{\link[=ssa.btl]{ssa.btl()}} for Examples.
}
\seealso{
\code{\link[=ssa.btl]{ssa.btl()}},
}
\keyword{datagen}
\keyword{misc}
\keyword{ts}
