% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictions.R
\name{cond_sim}
\alias{cond_sim}
\title{Conditional Simulation using Vecchia's approximation}
\usage{
cond_sim(covparms, covfun_name = "matern_isotropic", y_obs, locs_obs,
  locs_pred, X_obs, X_pred, beta, m = 60, nsims = 1, reorder = TRUE)
}
\arguments{
\item{covparms}{Covariance parameters}

\item{covfun_name}{Name of covariance function}

\item{y_obs}{Observations associated with locs_obs}

\item{locs_obs}{observation locations}

\item{locs_pred}{prediction locations}

\item{X_obs}{Design matrix for observations}

\item{X_pred}{Design matrix for predictions}

\item{beta}{Linear mean parameters}

\item{m}{Number of nearest neighbors to use. Larger \code{m} gives
better approximations.}

\item{nsims}{Number of conditional simulations to return.}

\item{reorder}{TRUE/FALSE for whether reordering should be done. This should
generally be kept at TRUE, unless testing out the effect of
reordering.}
}
\description{
With the prediction locations ordered after the observation locations,
an approximation for the inverse Cholesky of the covariance matrix
is computed, and standard formulas are applied to obtain
a conditional simulation.
}
