% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graph.R
\name{graph_prop}
\alias{graph_prop}
\title{Graph Prop}
\usage{
graph_prop(x, sigmaHat, thetaHat, prop = c("connectivity", "longest_chain",
  "max_degree", "largest_clique", "chromatic_number", "num_singletons", "girth",
  "matching", "planarity", "bipartite", "acyclic"), k = 1, numB = 1000,
  alpha = 0.05)
}
\arguments{
\item{x}{A sample of data}

\item{sigmaHat}{A sample covariance matrix for \code{x}}

\item{thetaHat}{A sample precision matrix estimated from \code{sigmaHat}}

\item{prop}{The monotone graph property to examine}

\item{k}{The value to threshold numeric tests at}

\item{numB}{The number of bootstrap samples to take Default: 1000}

\item{alpha}{The significance level for the property test Default: 0.05}
}
\value{
The value of \code{prop} with sig. level \code{alpha}
}
\description{
Computes the value of boolean property on an
estimated conditional independence graph.
}
\examples{

data(Xs,cov.hat,t.hat)
graph_prop(x=Xs,sigmaHat=cov.hat,thetaHat=t.hat,prop="conn",k=5)

}

