% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounding.seq.R
\name{bounding.seq}
\alias{bounding.seq}
\title{Bounding Sequence}
\usage{
bounding.seq(p.value, alpha)
}
\arguments{
\item{p.value}{A matrix of p-values from permutation: row is from each permutation; column is from each variable.}

\item{alpha}{Probability of Type I error for bounding sequence, the default value is 1 / sqrt(log(p)), where p is number of p-values in each permutation.}
}
\value{
A bounding value of higher criticism with (1 - alpha) confidence.
}
\description{
Calculates bounding sequence of higher crticism for proportion estimator using p-values
}
\examples{
set.seed(10)
X <- matrix(runif(n = 10000, min = 0, max = 1), nrow = 100)
result <- bounding.seq(p.value = X)

}
\references{
\insertRef{jeng2019efficient}{HCTR}
}
