% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_custom_portfol.R
\name{validate_MeanVar_portfolio}
\alias{validate_MeanVar_portfolio}
\title{A validator for objects of class MeanVar_portfolio}
\usage{
validate_MeanVar_portfolio(w)
}
\arguments{
\item{w}{Object of class MeanVar_portfolio.}
}
\value{
If the object passes all the checks, then w itself is returned,
otherwise an error is thrown.
}
\description{
A validator for objects of class MeanVar_portfolio
}
\examples{
n<-3e2 # number of realizations
p<-.5*n # number of assets
gamma<-1

x <- matrix(data = rnorm(n*p), nrow = p, ncol = n)

# Simple MV portfolio
cov_mtrx <- Sigma_sample_estimator(x)
means <- rowMeans(x)

cust_port_simp <- new_MeanVar_portfolio(mean_vec=means, cov_mtrx=cov_mtrx, gamma=2)
str(validate_MeanVar_portfolio(cust_port_simp))
}
