% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_all.R
\name{all_summary}
\alias{all_summary}
\title{Returns full summary table.}
\usage{
all_summary(filepath, replicates = 3, Dfact = 0.85)
}
\arguments{
\item{filepath}{filepath to the input file. Input file is All_results table from HDX_Examiner, where all the fields are marked for export.}

\item{replicates}{number of replicates. Default set to 3.}

\item{Dfact}{Dfact is the fraction of D/H in the labeling buffer used. Default set up to 0.85}
}
\value{
Returns summary table.
}
\description{
Returns summary data.
Function returns: Protein states, timepoints, number of replicates,  # peptides, \% coveregae, average peptide length and redundancy.
backexchange calculations (average and range), Critical interval and standard deviation.
Function requires undeuterated and Fully deuterated sets marked in Deut.time as 0s and FD respectively.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- all_summary(file_nm, replicates=3, Dfact=0.85)
}
