% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heat_map_max_uptake_proc.R
\name{plot_heat_map_max_uptake_tp_proc}
\alias{plot_heat_map_max_uptake_tp_proc}
\title{Plots heat maps for maximum procent deuteration per residue.}
\usage{
plot_heat_map_max_uptake_tp_proc(
  input_proc,
  input_up,
  mar_x = 3.5,
  ranges = c(-Inf, seq(-30, 30, by = 10), Inf),
  pv_cutoff = 0.01,
  replicates = 3
)
}
\arguments{
\item{input_proc}{Dataframe with organized procent deuteration data. Input generated using output_tp_proc() function.}

\item{input_up}{Dataframe with organized deuteration uptake. Input generated using output_tp() function.}

\item{mar_x}{margin x width. Default=3.5}

\item{ranges}{ranges for coloring scheme. Default set to c(-Inf, seq(-30, 30, by=10), Inf)}

\item{pv_cutoff}{p-value cutoff here set up to 0.01}

\item{replicates}{number of replicates in sample. Default set to 3.}
}
\value{
heat map for average uptake per residue for significant peptides.
}
\description{
Returns heat map with maximum precent_deuteration per residue.
}
\examples{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a_up<- output_tp(file_nm)
a_proc<- output_tp(file_nm, percent=TRUE)
plot_heat_map_max_uptake_tp_proc(input_proc=a_proc, input_up=a_up, replicates=3, pv_cutoff=0.01,
ranges=c(-Inf,-40, -30,-20,-10, 0,10, 20,30,40, Inf) )
plot_heat_map_max_uptake_tp_proc(input_proc=a_proc, input_up=a_up)
}
