% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPAV.R
\name{GPAV.over.examples}
\alias{GPAV.over.examples}
\title{GPAV Over Examples}
\usage{
GPAV.over.examples(S, g, W = NULL)
}
\arguments{
\item{S}{a named flat scores matrix with examples on rows and classes on columns (root node included)}

\item{g}{a graph of class \code{graphNEL}. It represents the hierarchy of the classes}

\item{W}{vector of weight relative to a single example. If the vector \code{W} is not specified (\code{def. W=NULL}), it is assumed that
\code{W} is a unitary vector of the same length of the columns' number of the matrix \code{S} (root node included)}
}
\value{
a named matrix with the scores of the classes corrected according to the GPAV algorithm
}
\description{
Function to compute GPAV across all the examples
}
\examples{
data(graph);
data(scores);
S.GPAV <- GPAV.over.examples(S,W=NULL,g);
}
\seealso{
\code{\link{GPAV.parallel}}
}
