% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpav.R
\name{gpav.over.examples}
\alias{gpav.over.examples}
\title{GPAV over examples}
\usage{
gpav.over.examples(S, g, W = NULL)
}
\arguments{
\item{S}{a named flat scores matrix with examples on rows and classes on columns (root node included).}

\item{g}{a graph of class \code{graphNEL}. It represents the hierarchy of the classes.}

\item{W}{vector of weight relative to a single example. If \code{W=NULL} (def.) it is assumed that
\code{W} is a unitary vector of the same length of the columns' number of the matrix \code{S} (root node included).}
}
\value{
A named matrix with the scores of the classes corrected according to the \code{GPAV} algorithm.
}
\description{
Compute \code{GPAV} across all the examples.
}
\examples{
data(graph);
data(scores);
S.gpav <- gpav.over.examples(S,W=NULL,g);
}
\seealso{
\code{\link{gpav.parallel}}
}
