% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLupdater.R
\name{multiUpdateGL}
\alias{multiUpdateGL}
\title{Update a column of GL String Code data to a desired IPD-IMGT/HLA Database version.}
\usage{
multiUpdateGL(GLstringArray, Version, expand = FALSE)
}
\arguments{
\item{GLstringArray}{An array of HLA allele names and operators in GL String code format identifying their relation with one another and the pertinent IPD-IMGT/HLA Database release version.}

\item{Version}{A character string identifying the desired version to which the alleles should be updated, going back to version 1.05.0.}

\item{expand}{A logical to determine whether to include only the direct HLA ID match, or all possible allele matches.}
}
\value{
A version of the input array of GL String Codes (in a data frame) updated to the desired version. NA values are returned in place of alleles that are not present in Version.
}
\description{
Updates a column from a data frame in GL String Code format to a desired reference database version.
}
\examples{
\donttest{
# Example update of two GL Strings Codes containing truncated alleles from version 3.1.0 to 3.53.0.
GLSC.ex[[2]][1:2] 
multiUpdateGL(GLSC.ex[[2]][1:2], Version = "3.53.0")
}

}
\references{
Mack et al. HLA 2023;102(2):206-212 https://doi.org/10.1111/tan.15126

Mack et al. HLA 05 July 2023 https://doi.org/10.1111/tan.15145
}
