% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.ohc.par.r
\name{calc.ohc.par}
\alias{calc.ohc.par}
\title{OHC Likelihood in Parallel}
\usage{
calc.ohc.par(pdt, filename, isotherm = "", ohc.dir, dateVec, bathy = TRUE,
  use.se = TRUE, ncores = NULL)
}
\arguments{
\item{pdt}{input PDT data see \code{\link{extract.pdt}}}

\item{filename}{is the first part of the filename specified to the download 
function \code{\link{get.env}}. For example, if downloaded files were 
specific to a particular dataset, you may want to identify that with a name
like 'tuna' or 'shark1'. This results in a downloaded filename of, for 
example, 'tuna_date.nc'. This filename is required here so the calc 
function knows where to get the env data.}

\item{isotherm}{default '' in which isotherm is calculated on the fly based 
on daily tag data. Otherwise, numeric isotherm constraint can be specified 
(e.g. 20 deg C).}

\item{ohc.dir}{directory of downloaded hycom (or other) data}

\item{dateVec}{vector of complete dates for data range. This should be in 
'Date' format}

\item{bathy}{is logical indicating whether or not a bathymetric mask should
be applied}

\item{use.se}{is logical indicating whether or not to use SE when using 
regression to predict temperature at specific depth levels.}

\item{ncores}{specify number of cores, or leave blank and use whatever you 
have!}
}
\value{
a raster brick of OHC likelihood
}
\description{
Calculate Ocean Heat Content (OHC) likelihood surface in parallel
}
\references{
Luo J, Ault JS, Shay LK, Hoolihan JP, Prince ED, Brown C a.,
  Rooker JR (2015) Ocean Heat Content Reveals Secrets of Fish Migrations.
  PLoS One 10:e0141101
}
\seealso{
\code{\link{calc.ohc}}
}
